package inc.monsters.mias.backing;

import inc.monsters.mias.data.Kid;
import inc.monsters.mias.data.statistics.AgeDistribution;
import inc.monsters.mias.data.statistics.AgeVsBraveness;
import inc.monsters.mias.data.statistics.KidsScaredPerMonth;
import inc.monsters.mias.data.statistics.KidsScaredThisMonth;
import inc.monsters.mias.data.statistics.XYData;

import java.util.List;

public class Statistics {
	private AgeDistribution ageDistribution;
	private AgeVsBraveness ageVsBraveness;
	private KidsScaredPerMonth kidsScaredPerMonth;
	private KidsScaredThisMonth kidsScaredThisMonth;
	private XYData xyData;
	
	private List<Kid> kids;

	public List<Kid> getKids() {
		return kids;
	}

	public void setKids(List<Kid> kids) {
		this.kids = kids;
	}

	public AgeDistribution getAgeDistribution() {
		if(null == ageDistribution) {
			ageDistribution = new AgeDistribution();
			ageDistribution.setKids(getKids());
		}
		return ageDistribution;
	}

	public AgeVsBraveness getAgeVsBraveness() {
		if(null == ageVsBraveness) {
			ageVsBraveness = new AgeVsBraveness();
			ageVsBraveness.setKids(getKids());
		}
		return ageVsBraveness;
	}

	public KidsScaredPerMonth getKidsScaredPerMonth() {
		if(null == kidsScaredPerMonth) {
			kidsScaredPerMonth = new KidsScaredPerMonth();
			kidsScaredPerMonth.setKids(getKids());
		}
		return kidsScaredPerMonth;
	}

	public KidsScaredThisMonth getKidsScaredThisMonth() {
		if(null == kidsScaredThisMonth) {
			kidsScaredThisMonth = new KidsScaredThisMonth();
			kidsScaredThisMonth.setKids(getKids());
		}
		return kidsScaredThisMonth;
	}

	public XYData getXyData() {
		if(null == xyData) {
			xyData = new XYData();
		}
		return xyData;
	}
}
